﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Public Class LoginForm

    Private Sub OK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OK.Click
        Dim samplePrincipal As New SampleIPrincipal(Me.UsernameTextBox.Text, Me.PasswordTextBox.Text)
        My.User.CurrentPrincipal = samplePrincipal

        If (Not My.User.IsAuthenticated) Then
            '使用 My.User 检查用户名和密码是否正确
            Me.UsernameTextBox.Text = String.Empty
            Me.PasswordTextBox.Text = String.Empty
            MessageBox.Show("Username or password are incorrect")
        Else
            '用户名和密码正确，因此显示主窗体。
            Me.Visible = False
            My.Forms.MainForm.Show()
        End If
    End Sub

    Private Sub Cancel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Cancel.Click
        Me.Close()
    End Sub

    Private Sub LoginForm1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        '如果当前用户没有经过身份验证，则提示输入用户名和密码并使用自定义
        'IPrincipal/IIdentity 对来执行自定义身份验证和授权。该示例
        '是一个不安全的 IPrincipal/IIdentity 实现。
        '
        '有关 IPrincipal 和 IIdentity 接口的更多信息，请参见
        'http://msdn.microsoft.com/library/default.asp?url=/library/en-us/dnnetsec/html/SecNetHT06.asp。
        If (My.User.IsAuthenticated) Then
            '用户已经过身份验证，因此显示主窗体。
            '用户尚未经过身份验证，因此启用自定义身份验证和授权
            Me.Close()
            My.Forms.MainForm.Show()
        End If
    End Sub
End Class
